﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using TMPro;
using UnityEngine;
using UnityEngine.SceneManagement;

//GameConfiguration is a script for managing the game configuration page UI
public class GameConfiguration : MonoBehaviour
{
    //UI Elements
    public TMP_InputField SeedTextBox;

    private List<LSystem> _LSystems;

    public void Start()
    {
        //Get our known L-Systems from resources, generate an initial seed
        _LSystems = Resources.LoadAll("L-Systems", typeof(LSystem)).ToList().Cast<LSystem>().ToList();
        GenerateSeed();
    }

    /// <summary>
    /// Plays the game by setting up the generation and beginning the loading process
    /// </summary>
    public void PlayGame()
    {
        int seedInt = Utilities.GetCitySeedIntFromString(SeedTextBox.text);

        if (seedInt != -1)
        {
            //We've got our seed as an integer, so use it to determine our initial generation parameters
            int index = Utilities.Wrap(seedInt, _LSystems.Count);
            GameController.Instance.LSystem = _LSystems[index];

            GameController.Instance.PerlinOffset = new Vector2Int(Utilities.Wrap(seedInt, ConfigurationManager.Instance.Generation.PerlinOffsetClamp), Utilities.Wrap(seedInt, ConfigurationManager.Instance.Generation.PerlinOffsetClamp));
            GameController.Instance.LSystem.IterationsClamp = Utilities.Wrap(seedInt, _LSystems[index].MaximumIterations - _LSystems[index].MinimumIterations) + _LSystems[index].MinimumIterations;
            GameController.Instance.CityDensity = Utilities.Wrap(seedInt, 100);
            GameController.Instance.CitySeed = seedInt;

            //Generation all set up, let's load
            AudioManager.Instance.StopMusic();
            Constants.LoadTask = new SceneLoadTask("GameScene", "LOADING GAME, PLEASE WAIT...");
            SceneManager.LoadScene("LoadingScene");
        }
    }

    /// <summary>
    /// Generates a new city seed and displays it in the UI
    /// </summary>
    public void GenerateSeed()
    {
        SeedTextBox.text = Utilities.GenerateRandomCitySeed();
    }
}
